<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityEvents\CreateRequest;
use App\Http\Resources\Web\EventsResource;
use Carbon\Carbon;
use Excel;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
class TherapistCommunityEventsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');
      // $this->middleware('permission:therapist_community_events.index');
      // $this->middleware('permission:therapist_community_events.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_events.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_events.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_events.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_events.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_events.update|therapist_community_events.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_events =  $therapist_community->therapist_community_events()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_events =  $therapist_community_events->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_events =  $therapist_community_events->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_events = $therapist_community_events->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_events = $therapist_community_events->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_events = $therapist_community_events->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_events = $therapist_community_events->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_events = $therapist_community_events->get();
        return $therapist_community_events;
      }
      $totalTherapistCommunityEvents = $therapist_community_events->count();
      $therapist_community_events = $therapist_community_events->paginate($req->perPage);
      $therapist_community_events = EventsResource::collection($therapist_community_events)->response()->getData(true);

      return $therapist_community_events;
    }
    $therapist_community_events = EventsResource::collection($therapist_community->therapist_community_events()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_events;
  }

  /********* FETCH ALL TherapistCommunityEvents ***********/
    public function index()
    {
        $therapist_community_events =  $this->getter();
        $response = generateResponse($therapist_community_events,count($therapist_community_events['data']) > 0 ? true:false,'TherapistCommunityEvents Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityEvents FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_events = $this->getter($request);
     $response = generateResponse($therapist_community_events,count($therapist_community_events['data']) > 0 ? true:false,'Filter TherapistCommunityEvents Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityEvent ***********/
    public function store(CreateRequest $request)
    {
      $therapist_community = auth()->user()->therapist_community;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_community_events');
      $therapist_community_event = $therapist_community->therapist_community_events()->create($data);
      $therapist_community_event->slug = Str::slug($therapist_community_event->name . ' ' . $therapist_community_event->id, '-');
      $therapist_community_event->save();
      $therapist_community_event = $therapist_community->therapist_community_events()->withAll()->find($therapist_community_event->id);
      foreach ($request->sponsers as $sponser) {
        $image_url = uploadArrayFile($sponser ,'image','event_sponsers');
        $therapist_community_event->sponsers()->create([
            'name' => $sponser['name'],
            'image' => $image_url
        ]);
      }
      $therapist_community_event = new EventsResource($therapist_community_event);
      $therapist_community_event->tags()->sync($request->tag_ids);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
        return redirect()->back()->withErrors(['line' => $e->getLine(),'message' => $e->getMessage()]);
    }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_event)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_event->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_event = $therapist_community->therapist_community_events()->withAll()->find($therapist_community_event);
        if($therapist_community_event){
          $therapist_community_event = new EventsResource($therapist_community_event);
          $response = generateResponse($therapist_community_event,true,'TherapistCommunityEvent Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityEvent Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityEvent ***********/
    public function update(CreateRequest $request, Event $therapist_community_event)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_event->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_events',$therapist_community_event->image);
        } else {
            $data['image'] = $therapist_community_event->image;
        }
        $therapist_community_event->sponsers()->delete();
        foreach ($request->sponsers as $sponser) {
        if (is_string($sponser['image'])) {
            $image_url = $sponser['previous_image'];
        }else{
            $image_url = uploadArrayFile($sponser ,'image','event_sponsers');
        }
            $therapist_community_event->sponsers()->create([
                'name' => $sponser['name'],
                'image' => $image_url
            ]);
          }
          $therapist_community_event->update($data);
          $therapist_community_event = $therapist_community_event->find($therapist_community_event->id);
          $slug = Str::slug($therapist_community_event['name'] . ' ' . $therapist_community_event->id, '-');
          $therapist_community_event->update(
              [
                  'slug' => $slug
              ]
          );
        $therapist_community_event->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
          return redirect()->back()->withErrors(['line' => $e->getLine(),'message' => $e->getMessage()]);
        }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunityEvent Status***********/
    public function updateStatus(Request $request,Event $therapist_community_event){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_event->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_event->update([
          'is_active' => $therapist_community_event->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunityEvent Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityEvent ***********/
    public function destroy(Request $request,Event $therapist_community_event)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_event->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_event->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_community_event->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityEvent ***********/
    public function destroyPermanently(Request $request,$therapist_community_event)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_event = $therapist_community->therapist_community_events()->withTrashed()->find($therapist_community_event);
        if($therapist_community_event){
            if($therapist_community_event->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_event->trashed()) {
            $therapist_community_event->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunityEvent Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityEvent is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityEvent not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityEvent ***********/
    public function restore(Request $request,$therapist_community_event)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_event = $therapist_community->therapist_community_events()->withTrashed()->find($therapist_community_event);
          if ($therapist_community_event->trashed()) {
            $therapist_community_event->restore();
            $response = generateResponse(null,true,'TherapistCommunityEvent Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityEvent is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
